(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27715,       1039]*)
(*NotebookOutlinePosition[     28557,       1066]*)
(*  CellTagsIndexPosition[     28513,       1062]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ 
      Example\ 3.2  .2 \((a)\)\ \ \[Lambda] = \(-1\)*) \[IndentingNewLine]\(k[
          x_, s_] := \ \((x - s)\)*\ Cos[x - s];\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ Cos[x];\)\), "\[IndentingNewLine]", 
    \(\(h = 0.1;\)\), "\[IndentingNewLine]", 
    \(a1 = h*k[h, 0]\), "\[IndentingNewLine]", 
    \(a2 = h*k[2  h, 0]/3\), "\[IndentingNewLine]", 
    \(a3 = 4*h*k[2\ h, h]/3\), "\[IndentingNewLine]", 
    \(a4 = 3*h*k[3\ h, 0]/8\), "\[IndentingNewLine]", 
    \(a5 = 9*h*k[3\ h, h]/8\), "\[IndentingNewLine]", 
    \(a6 = 9*h*k[3  h, 2\ h]/8\), "\[IndentingNewLine]", 
    \(a7 = h*k[4  h, 0]/3\), "\[IndentingNewLine]", 
    \(a8 = 4*h*k[4  h, h]/3\), "\[IndentingNewLine]", 
    \(a9 = 2*h*k[4  h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(c0 = 4*h*k[4\ h, 3\ h]/3\), "\[IndentingNewLine]", 
    \(c1 = h*k[5  h, 0]/3\), "\[IndentingNewLine]", 
    \(c2 = 4*h*k[5  h, h]/3\), "\[IndentingNewLine]", 
    \(c3 = 17*h*k[5  h, 2\ h]/24\), "\[IndentingNewLine]", 
    \(c4 = 9*h*k[5  h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(c5 = 9*h*k[5  h, 4  h]/8\), "\[IndentingNewLine]", 
    \(b1 = 1.  - h*k[h, h]/2\), "\[IndentingNewLine]", 
    \(b2 = 1.  - h*k[2\ h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(b3 = 1.  - \ 3*h*k[3\ h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(b4 = 1.  - h*k[4\ h, 4\ h]/3\), "\[IndentingNewLine]", 
    \(b5 = 1.  - 3*h*k[5\ h, 5\ h]/8\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\)}], "Input"],

Cell[BoxData[
    \(0.00995004165278026`\)], "Output"],

Cell[BoxData[
    \(0.006533777185608278`\)], "Output"],

Cell[BoxData[
    \(0.013266722203707013`\)], "Output"],

Cell[BoxData[
    \(0.01074753550266307`\)], "Output"],

Cell[BoxData[
    \(0.022051498001427944`\)], "Output"],

Cell[BoxData[
    \(0.011193796859377794`\)], "Output"],

Cell[BoxData[
    \(0.012280813253371804`\)], "Output"],

Cell[BoxData[
    \(0.03821345956502425`\)], "Output"],

Cell[BoxData[
    \(0.013067554371216556`\)], "Output"],

Cell[BoxData[
    \(0.013266722203707008`\)], "Output"],

Cell[BoxData[
    \(0.014626376031506214`\)], "Output"],

Cell[BoxData[
    \(0.04912325301348722`\)], "Output"],

Cell[BoxData[
    \(0.02030090039391913`\)], "Output"],

Cell[BoxData[
    \(0.02205149800142793`\)], "Output"],

Cell[BoxData[
    \(0.01119379685937779`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(phitil[h] = \((f[h] - a1*phitil[0])\)/b1\), "\[IndentingNewLine]", 
    \(phitil[2\ h] = \((f[2\ h] - a2*phitil[0] - a3*phitil[h])\)/
        b2\ \), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \((f[3\ h] - a4*phitil[0] - a5*phitil[h] - a6*phitil[2\ h])\)/
        b3\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \((f[4\ h] - a7*phitil[0] - a8*phitil[h] - a9*phitil[2\ h] - 
            c0*phitil[3\ h])\)/b4\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \((f[5\ h] - c1*phitil[0] - c2*phitil[h] - c3*phitil[2\ h] - 
            c4*phitil[3\ h] - c5*phitil[4\ h])\)/b5\)}], "Input"],

Cell[BoxData[
    \(0.9850541236252456`\)], "Output"],

Cell[BoxData[
    \(0.9604643612418811`\)], "Output"],

Cell[BoxData[
    \(0.9121157916341088`\)], "Output"],

Cell[BoxData[
    \(0.8464861477396315`\)], "Output"],

Cell[BoxData[
    \(0.7654799180441991`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][x_] := \((2*Cos[x*Sqrt[3]] + 1)\)/
          3;\)\), "\[IndentingNewLine]", 
    \(\[Phi][0.1]\)}], "Input"],

Cell[BoxData[
    \(0.9900249750133884`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.2]\)], "Input"],

Cell[BoxData[
    \(0.9603984034240041`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.3]\)], "Input"],

Cell[BoxData[
    \(0.9120068626074626`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.4]\)], "Input"],

Cell[BoxData[
    \(0.8462984730501204`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.5]\)], "Input"],

Cell[BoxData[
    \(0.7652395632349712`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Example\ 3.2  .2 \((b)\)\ \[Lambda] = 
        1\ *) \[IndentingNewLine]\(k[x_, s_] := \ \ Sin[
          x - s];\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ x;\)\), "\[IndentingNewLine]", 
    \(\(h = 0.1;\)\), "\[IndentingNewLine]", 
    \(a1 = h*k[h, 0]\), "\[IndentingNewLine]", 
    \(a2 = h*k[2  h, 0]/3\), "\[IndentingNewLine]", 
    \(a3 = 4*h*k[2\ h, h]/3\), "\[IndentingNewLine]", 
    \(a4 = 3*h*k[3\ h, 0]/8\), "\[IndentingNewLine]", 
    \(a5 = 9*h*k[3\ h, h]/8\), "\[IndentingNewLine]", 
    \(a6 = 9*h*k[3  h, 2\ h]/8\), "\[IndentingNewLine]", 
    \(a7 = h*k[4  h, 0]/3\), "\[IndentingNewLine]", 
    \(a8 = 4*h*k[4  h, h]/3\), "\[IndentingNewLine]", 
    \(a9 = 2*h*k[4  h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(c0 = 4*h*k[4\ h, 3\ h]/3\), "\[IndentingNewLine]", 
    \(c1 = h*k[5  h, 0]/3\), "\[IndentingNewLine]", 
    \(c2 = 4*h*k[5  h, h]/3\), "\[IndentingNewLine]", 
    \(c3 = 17*h*k[5  h, 2\ h]/24\), "\[IndentingNewLine]", 
    \(c4 = 9*h*k[5  h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(c5 = 9*h*k[5  h, 4  h]/8\), "\[IndentingNewLine]", 
    \(b1 = 1.  - h*k[h, h]/2\), "\[IndentingNewLine]", 
    \(b2 = 1.  - h*k[2\ h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(b3 = 1.  - \ 3*h*k[3\ h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(b4 = 1.  - h*k[4\ h, 4\ h]/3\), "\[IndentingNewLine]", 
    \(b5 = 1.  - 3*h*k[5\ h, 5\ h]/8\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\)}], "Input"],

Cell[BoxData[
    \(0.009983341664682815`\)], "Output"],

Cell[BoxData[
    \(0.0066223110265020415`\)], "Output"],

Cell[BoxData[
    \(0.013311122219577087`\)], "Output"],

Cell[BoxData[
    \(0.011082007749800235`\)], "Output"],

Cell[BoxData[
    \(0.022350299714444393`\)], "Output"],

Cell[BoxData[
    \(0.011231259372768171`\)], "Output"],

Cell[BoxData[
    \(0.012980611410288351`\)], "Output"],

Cell[BoxData[
    \(0.03940269422151195`\)], "Output"],

Cell[BoxData[
    \(0.013244622053004083`\)], "Output"],

Cell[BoxData[
    \(0.013311122219577086`\)], "Output"],

Cell[BoxData[
    \(0.015980851286806767`\)], "Output"],

Cell[BoxData[
    \(0.051922445641153406`\)], "Output"],

Cell[BoxData[
    \(0.02093268130517822`\)], "Output"],

Cell[BoxData[
    \(0.022350299714444383`\)], "Output"],

Cell[BoxData[
    \(0.011231259372768164`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(phitil[h] = \((f[h] + a1*phitil[0])\)/b1\), "\[IndentingNewLine]", 
    \(phitil[
        2\ h] = \(\((f[2\ h] + a2*phitil[0] + 
            a3*phitil[h])\)\(/\)\(b2\)\(\ \)\)\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \((f[3\ h] + a4*phitil[0] + a5*phitil[h] + a6*phitil[2\ h])\)/
        b3\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \((f[4\ h] + a7*phitil[0] + a8*phitil[h] + a9*phitil[2\ h] + 
            c0*phitil[3\ h])\)/b4\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \((f[5\ h] + c1*phitil[0] + c2*phitil[h] + c3*phitil[2\ h] + 
            c4*phitil[3\ h] + c5*phitil[4\ h])\)/b5\)}], "Input"],

Cell[BoxData[
    \(0.1`\)], "Output"],

Cell[BoxData[
    \(0.2013311122219577`\)], "Output"],

Cell[BoxData[
    \(0.30449623191261715`\)], "Output"],

Cell[BoxData[
    \(0.41066001046943157`\)], "Output"],

Cell[BoxData[
    \(0.5208244557098465`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][x_] := \ x + x^3/6;\)\), "\[IndentingNewLine]", 
    \(\[Phi][0.1]\)}], "Input"],

Cell[BoxData[
    \(0.10016666666666667`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.2]\)], "Input"],

Cell[BoxData[
    \(0.20133333333333334`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.3]\)], "Input"],

Cell[BoxData[
    \(0.3045`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.4]\)], "Input"],

Cell[BoxData[
    \(0.4106666666666667`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Phi][0.5]\)], "Input"],

Cell[BoxData[
    \(0.5208333333333334`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Example\ 3.2  .2 \((c)\)\ \[Lambda] = 
        1\ *) \[IndentingNewLine]\(k[x_, s_] := \ \ x - 
          s;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ Sin[x];\)\), "\[IndentingNewLine]", 
    \(\(h = 0.1;\)\), "\[IndentingNewLine]", 
    \(a1 = h*k[h, 0]\), "\[IndentingNewLine]", 
    \(a2 = h*k[2  h, 0]/3\), "\[IndentingNewLine]", 
    \(a3 = 4*h*k[2\ h, h]/3\), "\[IndentingNewLine]", 
    \(a4 = 3*h*k[3\ h, 0]/8\), "\[IndentingNewLine]", 
    \(a5 = 9*h*k[3\ h, h]/8\), "\[IndentingNewLine]", 
    \(a6 = 9*h*k[3  h, 2\ h]/8\), "\[IndentingNewLine]", 
    \(a7 = h*k[4  h, 0]/3\), "\[IndentingNewLine]", 
    \(a8 = 4*h*k[4  h, h]/3\), "\[IndentingNewLine]", 
    \(a9 = 2*h*k[4  h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(c0 = 4*h*k[4\ h, 3\ h]/3\), "\[IndentingNewLine]", 
    \(c1 = h*k[5  h, 0]/3\), "\[IndentingNewLine]", 
    \(c2 = 4*h*k[5  h, h]/3\), "\[IndentingNewLine]", 
    \(c3 = 17*h*k[5  h, 2\ h]/24\), "\[IndentingNewLine]", 
    \(c4 = 9*h*k[5  h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(c5 = 9*h*k[5  h, 4  h]/8\), "\[IndentingNewLine]", 
    \(b1 = 1.  - h*k[h, h]/2\), "\[IndentingNewLine]", 
    \(b2 = 1.  - h*k[2\ h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(b3 = 1.  - \ 3*h*k[3\ h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(b4 = 1.  - h*k[4\ h, 4\ h]/3\), "\[IndentingNewLine]", 
    \(b5 = 1.  - 3*h*k[5\ h, 5\ h]/8\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\), "\[IndentingNewLine]", 
    \(phitil[h] = \((f[h] + a1*phitil[0])\)/b1\), "\[IndentingNewLine]", 
    \(phitil[
        2\ h] = \(\((f[2\ h] + a2*phitil[0] + 
            a3*phitil[h])\)\(/\)\(b2\)\(\ \)\)\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \((f[3\ h] + a4*phitil[0] + a5*phitil[h] + a6*phitil[2\ h])\)/
        b3\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \((f[4\ h] + a7*phitil[0] + a8*phitil[h] + a9*phitil[2\ h] + 
            c0*phitil[3\ h])\)/b4\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \((f[5\ h] + c1*phitil[0] + c2*phitil[h] + c3*phitil[2\ h] + 
            c4*phitil[3\ h] + c5*phitil[4\ h])\)/b5\)}], "Input"],

Cell[BoxData[
    \(0.010000000000000002`\)], "Output"],

Cell[BoxData[
    \(0.006666666666666667`\)], "Output"],

Cell[BoxData[
    \(0.013333333333333334`\)], "Output"],

Cell[BoxData[
    \(0.011250000000000003`\)], "Output"],

Cell[BoxData[
    \(0.022500000000000006`\)], "Output"],

Cell[BoxData[
    \(0.011250000000000005`\)], "Output"],

Cell[BoxData[
    \(0.013333333333333334`\)], "Output"],

Cell[BoxData[
    \(0.04000000000000001`\)], "Output"],

Cell[BoxData[
    \(0.013333333333333334`\)], "Output"],

Cell[BoxData[
    \(0.01333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.016666666666666666`\)], "Output"],

Cell[BoxData[
    \(0.05333333333333334`\)], "Output"],

Cell[BoxData[
    \(0.02125`\)], "Output"],

Cell[BoxData[
    \(0.022499999999999996`\)], "Output"],

Cell[BoxData[
    \(0.011249999999999998`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(1.`\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(0.09983341664682815`\)], "Output"],

Cell[BoxData[
    \(0.20000044301701891`\)], "Output"],

Cell[BoxData[
    \(0.3000164635198347`\)], "Output"],

Cell[BoxData[
    \(0.4000785710616817`\)], "Output"],

Cell[BoxData[
    \(0.5002512512597856`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][x_] := \ \((Sin[x] + Cos[x])\)/2;\)\), "\[IndentingNewLine]", 
    \(\[Phi][0.1]\), "\[IndentingNewLine]", 
    \(\[Phi][0.2]\), "\[IndentingNewLine]", 
    \(\[Phi][0.3]\), "\[IndentingNewLine]", 
    \(\[Phi][0.4]\), "\[IndentingNewLine]", 
    \(\[Phi][0.5]\), "\[IndentingNewLine]", 
    \(ClearAll\)}], "Input"],

Cell[BoxData[
    \(0.547418790962427`\)], "Output"],

Cell[BoxData[
    \(0.5893679543181514`\)], "Output"],

Cell[BoxData[
    \(0.6254283478934728`\)], "Output"],

Cell[BoxData[
    \(0.6552396681557678`\)], "Output"],

Cell[BoxData[
    \(0.6785040502472879`\)], "Output"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Example\ 23.2  .2 \((d)\)\ \[Lambda] = 
        1\ *) \[IndentingNewLine]\(k[x_, s_] := 
        2*\ \ Cos[x - s];\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ Exp[x];\)\), "\[IndentingNewLine]", 
    \(\(h = 0.1;\)\), "\[IndentingNewLine]", 
    \(a1 = h*k[h, 0]\), "\[IndentingNewLine]", 
    \(a2 = h*k[2  h, 0]/3\), "\[IndentingNewLine]", 
    \(a3 = 4*h*k[2\ h, h]/3\), "\[IndentingNewLine]", 
    \(a4 = 3*h*k[3\ h, 0]/8\), "\[IndentingNewLine]", 
    \(a5 = 9*h*k[3\ h, h]/8\), "\[IndentingNewLine]", 
    \(a6 = 9*h*k[3  h, 2\ h]/8\), "\[IndentingNewLine]", 
    \(a7 = h*k[4  h, 0]/3\), "\[IndentingNewLine]", 
    \(a8 = 4*h*k[4  h, h]/3\), "\[IndentingNewLine]", 
    \(a9 = 2*h*k[4  h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(c0 = 4*h*k[4\ h, 3\ h]/3\), "\[IndentingNewLine]", 
    \(c1 = h*k[5  h, 0]/3\), "\[IndentingNewLine]", 
    \(c2 = 4*h*k[5  h, h]/3\), "\[IndentingNewLine]", 
    \(c3 = 17*h*k[5  h, 2\ h]/24\), "\[IndentingNewLine]", 
    \(c4 = 9*h*k[5  h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(c5 = 9*h*k[5  h, 4  h]/8\), "\[IndentingNewLine]", 
    \(b1 = 1.  - h*k[h, h]/2\), "\[IndentingNewLine]", 
    \(b2 = 1.  - h*k[2\ h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(b3 = 1.  - \ 3*h*k[3\ h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(b4 = 1.  - h*k[4\ h, 4\ h]/3\), "\[IndentingNewLine]", 
    \(b5 = 1.  - 3*h*k[5\ h, 5\ h]/8\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\), "\[IndentingNewLine]", 
    \(phitil[h] = \((f[h] + a1*phitil[0])\)/b1\), "\[IndentingNewLine]", 
    \(phitil[
        2\ h] = \(\((f[2\ h] + a2*phitil[0] + 
            a3*phitil[h])\)\(/\)\(b2\)\(\ \)\)\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \((f[3\ h] + a4*phitil[0] + a5*phitil[h] + a6*phitil[2\ h])\)/
        b3\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \((f[4\ h] + a7*phitil[0] + a8*phitil[h] + a9*phitil[2\ h] + 
            c0*phitil[3\ h])\)/b4\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \((f[5\ h] + c1*phitil[0] + c2*phitil[h] + c3*phitil[2\ h] + 
            c4*phitil[3\ h] + c5*phitil[4\ h])\)/b5\)}], "Input"],

Cell[BoxData[
    \(0.19900083305560518`\)], "Output"],

Cell[BoxData[
    \(0.06533777185608278`\)], "Output"],

Cell[BoxData[
    \(0.26533444407414025`\)], "Output"],

Cell[BoxData[
    \(0.07165023668442046`\)], "Output"],

Cell[BoxData[
    \(0.22051498001427938`\)], "Output"],

Cell[BoxData[
    \(0.2238759371875558`\)], "Output"],

Cell[BoxData[
    \(0.06140406626685901`\)], "Output"],

Cell[BoxData[
    \(0.25475639710016157`\)], "Output"],

Cell[BoxData[
    \(0.13067554371216555`\)], "Output"],

Cell[BoxData[
    \(0.26533444407414025`\)], "Output"],

Cell[BoxData[
    \(0.05850550412602486`\)], "Output"],

Cell[BoxData[
    \(0.24561626506743603`\)], "Output"],

Cell[BoxData[
    \(0.13533933595946085`\)], "Output"],

Cell[BoxData[
    \(0.22051498001427938`\)], "Output"],

Cell[BoxData[
    \(0.22387593718755583`\)], "Output"],

Cell[BoxData[
    \(0.9`\)], "Output"],

Cell[BoxData[
    \(0.9333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.925`\)], "Output"],

Cell[BoxData[
    \(0.9333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.925`\)], "Output"],

Cell[BoxData[
    \(1\)], "Output"],

Cell[BoxData[
    \(1.44907972347917`\)], "Output"],

Cell[BoxData[
    \(1.7906049566407576`\)], "Output"],

Cell[BoxData[
    \(2.315595884673689`\)], "Output"],

Cell[BoxData[
    \(2.9687000533023973`\)], "Output"],

Cell[BoxData[
    \(3.7629488616014335`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][x_] := \ Exp[x]*\((1 + x)\)^2;\)\), "\[IndentingNewLine]", 
    \(\[Phi][0.1]\), "\[IndentingNewLine]", 
    \(\[Phi][0.2]\), "\[IndentingNewLine]", 
    \(\[Phi][0.3]\), "\[IndentingNewLine]", 
    \(\[Phi][0.4]\), "\[IndentingNewLine]", 
    \(\[Phi][0.5]\)}], "Input"],

Cell[BoxData[
    \(1.337256810871534`\)], "Output"],

Cell[BoxData[
    \(1.7588199717506445`\)], "Output"],

Cell[BoxData[
    \(2.2812613848034458`\)], "Output"],

Cell[BoxData[
    \(2.9239764073768897`\)], "Output"],

Cell[BoxData[
    \(3.7096228590752887`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Example\ 3.2  .2 \((e)\)\ \[Lambda] = 
        1\ *) \[IndentingNewLine]\(k[x_, s_] := 
        1;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ Cos[x];\)\), "\[IndentingNewLine]", 
    \(\(h = 0.1;\)\), "\[IndentingNewLine]", 
    \(a1 = h*k[h, 0]\), "\[IndentingNewLine]", 
    \(a2 = h*k[2  h, 0]/3\), "\[IndentingNewLine]", 
    \(a3 = 4*h*k[2\ h, h]/3\), "\[IndentingNewLine]", 
    \(a4 = 3*h*k[3\ h, 0]/8\), "\[IndentingNewLine]", 
    \(a5 = 9*h*k[3\ h, h]/8\), "\[IndentingNewLine]", 
    \(a6 = 9*h*k[3  h, 2\ h]/8\), "\[IndentingNewLine]", 
    \(a7 = h*k[4  h, 0]/3\), "\[IndentingNewLine]", 
    \(a8 = 4*h*k[4  h, h]/3\), "\[IndentingNewLine]", 
    \(a9 = 2*h*k[4  h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(c0 = 4*h*k[4\ h, 3\ h]/3\), "\[IndentingNewLine]", 
    \(c1 = h*k[5  h, 0]/3\), "\[IndentingNewLine]", 
    \(c2 = 4*h*k[5  h, h]/3\), "\[IndentingNewLine]", 
    \(c3 = 17*h*k[5  h, 2\ h]/24\), "\[IndentingNewLine]", 
    \(c4 = 9*h*k[5  h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(c5 = 9*h*k[5  h, 4  h]/8\), "\[IndentingNewLine]", 
    \(b1 = 1.  - h*k[h, h]/2\), "\[IndentingNewLine]", 
    \(b2 = 1.  - h*k[2\ h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(b3 = 1.  - \ 3*h*k[3\ h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(b4 = 1.  - h*k[4\ h, 4\ h]/3\), "\[IndentingNewLine]", 
    \(b5 = 1.  - 3*h*k[5\ h, 5\ h]/8\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\), "\[IndentingNewLine]", 
    \(phitil[h] = \((f[h] + a1*phitil[0])\)/b1\), "\[IndentingNewLine]", 
    \(phitil[
        2\ h] = \(\((f[2\ h] + a2*phitil[0] + 
            a3*phitil[h])\)\(/\)\(b2\)\(\ \)\)\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \((f[3\ h] + a4*phitil[0] + a5*phitil[h] + a6*phitil[2\ h])\)/
        b3\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \((f[4\ h] + a7*phitil[0] + a8*phitil[h] + a9*phitil[2\ h] + 
            c0*phitil[3\ h])\)/b4\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \((f[5\ h] + c1*phitil[0] + c2*phitil[h] + c3*phitil[2\ h] + 
            c4*phitil[3\ h] + c5*phitil[4\ h])\)/b5\)}], "Input"],

Cell[BoxData[
    \(0.1`\)], "Output"],

Cell[BoxData[
    \(0.03333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.13333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.037500000000000006`\)], "Output"],

Cell[BoxData[
    \(0.1125`\)], "Output"],

Cell[BoxData[
    \(0.1125`\)], "Output"],

Cell[BoxData[
    \(0.03333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.13333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.06666666666666667`\)], "Output"],

Cell[BoxData[
    \(0.13333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.03333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.13333333333333333`\)], "Output"],

Cell[BoxData[
    \(0.07083333333333335`\)], "Output"],

Cell[BoxData[
    \(0.1125`\)], "Output"],

Cell[BoxData[
    \(0.1125`\)], "Output"],

Cell[BoxData[
    \(0.95`\)], "Output"],

Cell[BoxData[
    \(0.9666666666666667`\)], "Output"],

Cell[BoxData[
    \(0.9625`\)], "Output"],

Cell[BoxData[
    \(0.9666666666666667`\)], "Output"],

Cell[BoxData[
    \(0.9625`\)], "Output"],

Cell[BoxData[
    \(1\)], "Output"],

Cell[BoxData[
    \(1.1526359634505534`\)], "Output"],

Cell[BoxData[
    \(1.2073290065186022`\)], "Output"],

Cell[BoxData[
    \(1.3073584916853358`\)], "Output"],

Cell[BoxData[
    \(1.4098781259885282`\)], "Output"],

Cell[BoxData[
    \(1.5125287769355746`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][x_] := \ \((Exp[x] + Cos[x] + Sin[x])\)/
          2;\)\), "\[IndentingNewLine]", 
    \(\[Phi][0.1]\), "\[IndentingNewLine]", 
    \(\[Phi][0.2]\), "\[IndentingNewLine]", 
    \(\[Phi][0.3]\), "\[IndentingNewLine]", 
    \(\[Phi][0.4]\), "\[IndentingNewLine]", 
    \(\[Phi][0.5]\)}], "Input"],

Cell[BoxData[
    \(1.1000042500002507`\)], "Output"],

Cell[BoxData[
    \(1.2000693333982364`\)], "Output"],

Cell[BoxData[
    \(1.3003577516814744`\)], "Output"],

Cell[BoxData[
    \(1.401152016976403`\)], "Output"],

Cell[BoxData[
    \(1.502864685597352`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ 
      Example\ 3.2  .2 \((f)\)\ \[Lambda] = \(-1\)\ *) \[IndentingNewLine]\(k[
          x_, s_] := Cosh[x - s];\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := \ Sinh[x];\)\), "\[IndentingNewLine]", 
    \(\(h = 0.1;\)\), "\[IndentingNewLine]", 
    \(a1 = h*k[h, 0]\), "\[IndentingNewLine]", 
    \(a2 = h*k[2  h, 0]/3\), "\[IndentingNewLine]", 
    \(a3 = 4*h*k[2\ h, h]/3\), "\[IndentingNewLine]", 
    \(a4 = 3*h*k[3\ h, 0]/8\), "\[IndentingNewLine]", 
    \(a5 = 9*h*k[3\ h, h]/8\), "\[IndentingNewLine]", 
    \(a6 = 9*h*k[3  h, 2\ h]/8\), "\[IndentingNewLine]", 
    \(a7 = h*k[4  h, 0]/3\), "\[IndentingNewLine]", 
    \(a8 = 4*h*k[4  h, h]/3\), "\[IndentingNewLine]", 
    \(a9 = 2*h*k[4  h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(c0 = 4*h*k[4\ h, 3\ h]/3\), "\[IndentingNewLine]", 
    \(c1 = h*k[5  h, 0]/3\), "\[IndentingNewLine]", 
    \(c2 = 4*h*k[5  h, h]/3\), "\[IndentingNewLine]", 
    \(c3 = 17*h*k[5  h, 2\ h]/24\), "\[IndentingNewLine]", 
    \(c4 = 9*h*k[5  h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(c5 = 9*h*k[5  h, 4  h]/8\), "\[IndentingNewLine]", 
    \(b1 = 1.  - h*k[h, h]/2\), "\[IndentingNewLine]", 
    \(b2 = 1.  - h*k[2\ h, 2\ h]/3\), "\[IndentingNewLine]", 
    \(b3 = 1.  - \ 3*h*k[3\ h, 3\ h]/8\), "\[IndentingNewLine]", 
    \(b4 = 1.  - h*k[4\ h, 4\ h]/3\), "\[IndentingNewLine]", 
    \(b5 = 1.  - 3*h*k[5\ h, 5\ h]/8\), "\[IndentingNewLine]", 
    \(phitil[0] = f[0]\), "\[IndentingNewLine]", 
    \(phitil[h] = \((f[h] - a1*phitil[0])\)/b1\), "\[IndentingNewLine]", 
    \(phitil[
        2\ h] = \(\((f[2\ h] - a2*phitil[0] - 
            a3*phitil[h])\)\(/\)\(b2\)\(\ \)\)\), "\[IndentingNewLine]", 
    \(phitil[
        3\ h] = \((f[3\ h] - a4*phitil[0] - a5*phitil[h] - a6*phitil[2\ h])\)/
        b3\), "\[IndentingNewLine]", 
    \(phitil[
        4\ h] = \((f[4\ h] - a7*phitil[0] - a8*phitil[h] - a9*phitil[2\ h] - 
            c0*phitil[3\ h])\)/b4\), "\[IndentingNewLine]", 
    \(phitil[
        5\ h] = \((f[5\ h] - c1*phitil[0] - c2*phitil[h] - c3*phitil[2\ h] - 
            c4*phitil[3\ h] - c5*phitil[4\ h])\)/b5\)}], "Input"],

Cell[BoxData[
    \(0.10050041680558036`\)], "Output"],

Cell[BoxData[
    \(0.03400222518730253`\)], "Output"],

Cell[BoxData[
    \(0.13400055574077382`\)], "Output"],

Cell[BoxData[
    \(0.03920019427983227`\)], "Output"],

Cell[BoxData[
    \(0.11475751000714605`\)], "Output"],

Cell[BoxData[
    \(0.1130629689062779`\)], "Output"],

Cell[BoxData[
    \(0.0360357457279485`\)], "Output"],

Cell[BoxData[
    \(0.13937846855051472`\)], "Output"],

Cell[BoxData[
    \(0.06800445037460506`\)], "Output"],

Cell[BoxData[
    \(0.13400055574077382`\)], "Output"],

Cell[BoxData[
    \(0.037587532173546025`\)], "Output"],

Cell[BoxData[
    \(0.144142982911794`\)], "Output"],

Cell[BoxData[
    \(0.07404481141746094`\)], "Output"],

Cell[BoxData[
    \(0.11475751000714605`\)], "Output"],

Cell[BoxData[
    \(0.1130629689062779`\)], "Output"],

Cell[BoxData[
    \(0.95`\)], "Output"],

Cell[BoxData[
    \(0.9666666666666667`\)], "Output"],

Cell[BoxData[
    \(0.9625`\)], "Output"],

Cell[BoxData[
    \(0.9666666666666667`\)], "Output"],

Cell[BoxData[
    \(0.9625`\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(0.10543868423141477`\)], "Output"],

Cell[BoxData[
    \(0.1936625795767329`\)], "Output"],

Cell[BoxData[
    \(0.28106425597228263`\)], "Output"],

Cell[BoxData[
    \(0.3571280272626856`\)], "Output"],

Cell[BoxData[
    \(0.4352469201471238`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Phi][x_] := \ 
        2*Sinh[x*Sqrt[5]/2]*
          Exp[\(-x\)/2]/Sqrt[5];\)\), "\[IndentingNewLine]", 
    \(\[Phi][0.1]\), "\[IndentingNewLine]", 
    \(\[Phi][0.2]\), "\[IndentingNewLine]", 
    \(\[Phi][0.3]\), "\[IndentingNewLine]", 
    \(\[Phi][0.4]\), "\[IndentingNewLine]", 
    \(\[Phi][0.5]\)}], "Input"],

Cell[BoxData[
    \(0.09532123914170927`\)], "Output"],

Cell[BoxData[
    \(0.1824793206178928`\)], "Output"],

Cell[BoxData[
    \(0.26308118169376227`\)], "Output"],

Cell[BoxData[
    \(0.3385183966482908`\)], "Output"],

Cell[BoxData[
    \(0.41000092488950424`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 1464, 26, 411, "Input"],
Cell[3206, 79, 54, 1, 26, "Output"],
Cell[3263, 82, 55, 1, 26, "Output"],
Cell[3321, 85, 55, 1, 26, "Output"],
Cell[3379, 88, 54, 1, 26, "Output"],
Cell[3436, 91, 55, 1, 26, "Output"],
Cell[3494, 94, 55, 1, 26, "Output"],
Cell[3552, 97, 55, 1, 26, "Output"],
Cell[3610, 100, 54, 1, 26, "Output"],
Cell[3667, 103, 55, 1, 26, "Output"],
Cell[3725, 106, 55, 1, 26, "Output"],
Cell[3783, 109, 55, 1, 26, "Output"],
Cell[3841, 112, 54, 1, 26, "Output"],
Cell[3898, 115, 54, 1, 26, "Output"],
Cell[3955, 118, 54, 1, 26, "Output"],
Cell[4012, 121, 54, 1, 26, "Output"],
Cell[4069, 124, 37, 1, 26, "Output"],
Cell[4109, 127, 37, 1, 26, "Output"],
Cell[4149, 130, 37, 1, 26, "Output"],
Cell[4189, 133, 37, 1, 26, "Output"],
Cell[4229, 136, 37, 1, 26, "Output"],
Cell[4269, 139, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4341, 145, 636, 12, 187, "Input"],
Cell[4980, 159, 53, 1, 26, "Output"],
Cell[5036, 162, 53, 1, 26, "Output"],
Cell[5092, 165, 53, 1, 26, "Output"],
Cell[5148, 168, 53, 1, 26, "Output"],
Cell[5204, 171, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5294, 177, 138, 3, 43, "Input"],
Cell[5435, 182, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5525, 188, 44, 1, 27, "Input"],
Cell[5572, 191, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5662, 197, 44, 1, 27, "Input"],
Cell[5709, 200, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5799, 206, 44, 1, 27, "Input"],
Cell[5846, 209, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5936, 215, 44, 1, 27, "Input"],
Cell[5983, 218, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6073, 224, 41, 1, 27, "Input"],
Cell[6117, 227, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6196, 233, 1444, 26, 411, "Input"],
Cell[7643, 261, 55, 1, 26, "Output"],
Cell[7701, 264, 56, 1, 26, "Output"],
Cell[7760, 267, 55, 1, 26, "Output"],
Cell[7818, 270, 55, 1, 26, "Output"],
Cell[7876, 273, 55, 1, 26, "Output"],
Cell[7934, 276, 55, 1, 26, "Output"],
Cell[7992, 279, 55, 1, 26, "Output"],
Cell[8050, 282, 54, 1, 26, "Output"],
Cell[8107, 285, 55, 1, 26, "Output"],
Cell[8165, 288, 55, 1, 26, "Output"],
Cell[8223, 291, 55, 1, 26, "Output"],
Cell[8281, 294, 55, 1, 26, "Output"],
Cell[8339, 297, 54, 1, 26, "Output"],
Cell[8396, 300, 55, 1, 26, "Output"],
Cell[8454, 303, 55, 1, 26, "Output"],
Cell[8512, 306, 37, 1, 26, "Output"],
Cell[8552, 309, 37, 1, 26, "Output"],
Cell[8592, 312, 37, 1, 26, "Output"],
Cell[8632, 315, 37, 1, 26, "Output"],
Cell[8672, 318, 37, 1, 26, "Output"],
Cell[8712, 321, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8784, 327, 665, 13, 187, "Input"],
Cell[9452, 342, 38, 1, 26, "Output"],
Cell[9493, 345, 53, 1, 26, "Output"],
Cell[9549, 348, 54, 1, 26, "Output"],
Cell[9606, 351, 54, 1, 26, "Output"],
Cell[9663, 354, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9753, 360, 110, 2, 43, "Input"],
Cell[9866, 364, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9957, 370, 44, 1, 27, "Input"],
Cell[10004, 373, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10095, 379, 44, 1, 27, "Input"],
Cell[10142, 382, 41, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10220, 388, 44, 1, 27, "Input"],
Cell[10267, 391, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10357, 397, 44, 1, 27, "Input"],
Cell[10404, 400, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10494, 406, 41, 1, 27, "Input"],
Cell[10538, 409, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10617, 415, 2108, 39, 587, "Input"],
Cell[12728, 456, 55, 1, 26, "Output"],
Cell[12786, 459, 55, 1, 26, "Output"],
Cell[12844, 462, 55, 1, 26, "Output"],
Cell[12902, 465, 55, 1, 26, "Output"],
Cell[12960, 468, 55, 1, 26, "Output"],
Cell[13018, 471, 55, 1, 26, "Output"],
Cell[13076, 474, 55, 1, 26, "Output"],
Cell[13134, 477, 54, 1, 26, "Output"],
Cell[13191, 480, 55, 1, 26, "Output"],
Cell[13249, 483, 54, 1, 26, "Output"],
Cell[13306, 486, 55, 1, 26, "Output"],
Cell[13364, 489, 54, 1, 26, "Output"],
Cell[13421, 492, 42, 1, 26, "Output"],
Cell[13466, 495, 55, 1, 26, "Output"],
Cell[13524, 498, 55, 1, 26, "Output"],
Cell[13582, 501, 37, 1, 26, "Output"],
Cell[13622, 504, 37, 1, 26, "Output"],
Cell[13662, 507, 37, 1, 26, "Output"],
Cell[13702, 510, 37, 1, 26, "Output"],
Cell[13742, 513, 37, 1, 26, "Output"],
Cell[13782, 516, 35, 1, 26, "Output"],
Cell[13820, 519, 54, 1, 26, "Output"],
Cell[13877, 522, 54, 1, 26, "Output"],
Cell[13934, 525, 53, 1, 26, "Output"],
Cell[13990, 528, 53, 1, 26, "Output"],
Cell[14046, 531, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14136, 537, 346, 7, 123, "Input"],
Cell[14485, 546, 52, 1, 26, "Output"],
Cell[14540, 549, 53, 1, 26, "Output"],
Cell[14596, 552, 53, 1, 26, "Output"],
Cell[14652, 555, 53, 1, 26, "Output"],
Cell[14708, 558, 53, 1, 26, "Output"],
Cell[14764, 561, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14843, 567, 2114, 39, 587, "Input"],
Cell[16960, 608, 54, 1, 26, "Output"],
Cell[17017, 611, 54, 1, 26, "Output"],
Cell[17074, 614, 54, 1, 26, "Output"],
Cell[17131, 617, 54, 1, 26, "Output"],
Cell[17188, 620, 54, 1, 26, "Output"],
Cell[17245, 623, 53, 1, 26, "Output"],
Cell[17301, 626, 54, 1, 26, "Output"],
Cell[17358, 629, 54, 1, 26, "Output"],
Cell[17415, 632, 54, 1, 26, "Output"],
Cell[17472, 635, 54, 1, 26, "Output"],
Cell[17529, 638, 54, 1, 26, "Output"],
Cell[17586, 641, 54, 1, 26, "Output"],
Cell[17643, 644, 54, 1, 26, "Output"],
Cell[17700, 647, 54, 1, 26, "Output"],
Cell[17757, 650, 54, 1, 26, "Output"],
Cell[17814, 653, 38, 1, 26, "Output"],
Cell[17855, 656, 53, 1, 26, "Output"],
Cell[17911, 659, 40, 1, 26, "Output"],
Cell[17954, 662, 53, 1, 26, "Output"],
Cell[18010, 665, 40, 1, 26, "Output"],
Cell[18053, 668, 35, 1, 26, "Output"],
Cell[18091, 671, 51, 1, 26, "Output"],
Cell[18145, 674, 53, 1, 26, "Output"],
Cell[18201, 677, 52, 1, 26, "Output"],
Cell[18256, 680, 53, 1, 26, "Output"],
Cell[18312, 683, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18402, 689, 301, 6, 107, "Input"],
Cell[18706, 697, 52, 1, 26, "Output"],
Cell[18761, 700, 53, 1, 26, "Output"],
Cell[18817, 703, 53, 1, 26, "Output"],
Cell[18873, 706, 53, 1, 26, "Output"],
Cell[18929, 709, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19019, 715, 41, 1, 27, "Input"],
Cell[19063, 718, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19142, 724, 2098, 39, 587, "Input"],
Cell[21243, 765, 38, 1, 26, "Output"],
Cell[21284, 768, 54, 1, 26, "Output"],
Cell[21341, 771, 54, 1, 26, "Output"],
Cell[21398, 774, 55, 1, 26, "Output"],
Cell[21456, 777, 41, 1, 26, "Output"],
Cell[21500, 780, 41, 1, 26, "Output"],
Cell[21544, 783, 54, 1, 26, "Output"],
Cell[21601, 786, 54, 1, 26, "Output"],
Cell[21658, 789, 54, 1, 26, "Output"],
Cell[21715, 792, 54, 1, 26, "Output"],
Cell[21772, 795, 54, 1, 26, "Output"],
Cell[21829, 798, 54, 1, 26, "Output"],
Cell[21886, 801, 54, 1, 26, "Output"],
Cell[21943, 804, 41, 1, 26, "Output"],
Cell[21987, 807, 41, 1, 26, "Output"],
Cell[22031, 810, 39, 1, 26, "Output"],
Cell[22073, 813, 53, 1, 26, "Output"],
Cell[22129, 816, 41, 1, 26, "Output"],
Cell[22173, 819, 53, 1, 26, "Output"],
Cell[22229, 822, 41, 1, 26, "Output"],
Cell[22273, 825, 35, 1, 26, "Output"],
Cell[22311, 828, 53, 1, 26, "Output"],
Cell[22367, 831, 53, 1, 26, "Output"],
Cell[22423, 834, 53, 1, 26, "Output"],
Cell[22479, 837, 53, 1, 26, "Output"],
Cell[22535, 840, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22625, 846, 324, 7, 107, "Input"],
Cell[22952, 855, 53, 1, 26, "Output"],
Cell[23008, 858, 53, 1, 26, "Output"],
Cell[23064, 861, 53, 1, 26, "Output"],
Cell[23120, 864, 52, 1, 26, "Output"],
Cell[23175, 867, 52, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23264, 873, 41, 1, 27, "Input"],
Cell[23308, 876, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23387, 882, 2114, 39, 587, "Input"],
Cell[25504, 923, 54, 1, 26, "Output"],
Cell[25561, 926, 54, 1, 26, "Output"],
Cell[25618, 929, 54, 1, 26, "Output"],
Cell[25675, 932, 54, 1, 26, "Output"],
Cell[25732, 935, 54, 1, 26, "Output"],
Cell[25789, 938, 53, 1, 26, "Output"],
Cell[25845, 941, 53, 1, 26, "Output"],
Cell[25901, 944, 54, 1, 26, "Output"],
Cell[25958, 947, 54, 1, 26, "Output"],
Cell[26015, 950, 54, 1, 26, "Output"],
Cell[26072, 953, 55, 1, 26, "Output"],
Cell[26130, 956, 52, 1, 26, "Output"],
Cell[26185, 959, 54, 1, 26, "Output"],
Cell[26242, 962, 54, 1, 26, "Output"],
Cell[26299, 965, 53, 1, 26, "Output"],
Cell[26355, 968, 39, 1, 26, "Output"],
Cell[26397, 971, 53, 1, 26, "Output"],
Cell[26453, 974, 41, 1, 26, "Output"],
Cell[26497, 977, 53, 1, 26, "Output"],
Cell[26553, 980, 41, 1, 26, "Output"],
Cell[26597, 983, 35, 1, 26, "Output"],
Cell[26635, 986, 54, 1, 26, "Output"],
Cell[26692, 989, 53, 1, 26, "Output"],
Cell[26748, 992, 54, 1, 26, "Output"],
Cell[26805, 995, 53, 1, 26, "Output"],
Cell[26861, 998, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26951, 1004, 342, 8, 107, "Input"],
Cell[27296, 1014, 54, 1, 26, "Output"],
Cell[27353, 1017, 53, 1, 26, "Output"],
Cell[27409, 1020, 54, 1, 26, "Output"],
Cell[27466, 1023, 53, 1, 26, "Output"],
Cell[27522, 1026, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27613, 1032, 41, 1, 27, "Input"],
Cell[27657, 1035, 42, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

